/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.LongValueException;

public class FlexFormat {
    public static final int AUTO_PRECISION = -1;
    public static final int DOUBLE_DECIMALS = 16;
    public static final int FLOAT_DECIMALS = 7;
    public static final int MIN_BIGINT_EFORM_DECIMALS = 18;
    private static final double MAX_FIXED = 1000000.0;
    private static final double MIN_FIXED = 0.001;
    private int decimals = -1;
    private int width = 80;
    private static final DecimalFormatSymbols SYMBOLS = DecimalFormatSymbols.getInstance(Locale.US);

    public synchronized FlexFormat setPrecision(int nDecimals) {
        this.decimals = nDecimals < 0 ? -1 : nDecimals;
        return this;
    }

    public synchronized FlexFormat autoPrecision() {
        return this.setPrecision(-1);
    }

    public final synchronized int getPrecision() {
        return this.decimals;
    }

    public synchronized FlexFormat setWidth(int nChars) {
        this.width = nChars > 0 ? nChars : 0;
        return this;
    }

    public final FlexFormat forCard(HeaderCard card) {
        return this.setWidth(card.spaceForValue());
    }

    public final synchronized int getWidth() {
        return this.width;
    }

    private static boolean isDecimal(Number value) {
        return value instanceof Float || value instanceof Double || value instanceof BigDecimal;
    }

    public synchronized String format(Number value) throws LongValueException {
        double a;
        if (value == null) {
            return "";
        }
        String fixed = null;
        if (!FlexFormat.isDecimal(value)) {
            fixed = value.toString();
            if (fixed.length() <= this.width) {
                return fixed;
            }
            if (!(value instanceof BigInteger)) {
                throw new LongValueException(this.width, fixed);
            }
            fixed = null;
        } else if (this.decimals < 0 && (a = Math.abs(value.doubleValue())) >= 0.001 && a < 1000000.0) {
            try {
                fixed = this.format(value, "0.#", -1, false);
            }
            catch (LongValueException longValueException) {
                // empty catch block
            }
        }
        String exp = null;
        try {
            exp = this.format(value, "0.#E0", this.decimals, FitsFactory.isUseExponentD());
            if (fixed == null) {
                return exp;
            }
            return exp.length() < fixed.length() ? exp : fixed;
        }
        catch (LongValueException e) {
            if (fixed == null) {
                throw e;
            }
            return fixed;
        }
    }

    private synchronized String format(Number value, String fmt, int nDecimals, boolean allowUseD) throws LongValueException {
        if (this.width < 1) {
            throw new LongValueException(this.width);
        }
        DecimalFormat f = new DecimalFormat(fmt);
        f.setDecimalFormatSymbols(SYMBOLS);
        f.setDecimalSeparatorAlwaysShown(true);
        f.setRoundingMode(RoundingMode.HALF_UP);
        if (nDecimals < 0) {
            nDecimals = value instanceof BigDecimal || value instanceof BigInteger ? this.width : (value instanceof Double ? 16 : 7);
        }
        f.setMinimumFractionDigits(fmt.indexOf(69) < 0 ? 1 : 0);
        f.setMaximumFractionDigits(nDecimals);
        String text = f.format(value);
        while (text.length() > this.width) {
            int delta = text.length() - this.width;
            if (value instanceof BigInteger && (nDecimals -= delta) < 18 || !(value instanceof BigInteger) && nDecimals < 16) {
                throw new LongValueException(this.width, text);
            }
            f.setMaximumFractionDigits(nDecimals);
            text = f.format(value);
        }
        if (allowUseD && nDecimals > 7) {
            text = text.replace('E', 'D');
        }
        return text;
    }
}

