/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.NoSuchElementException;
import nom.tam.fits.header.FitsKey;
import nom.tam.util.Cursor;
import nom.tam.util.CursorValue;

public class HashedList<VALUE extends CursorValue<String>>
implements Collection<VALUE> {
    private final ArrayList<VALUE> ordered = new ArrayList();
    private final HashMap<String, VALUE> keyed = new HashMap();
    private HashedListIterator cursor = new HashedListIterator(0);

    private void add(int pos, VALUE entry) {
        String key = (String)entry.getKey();
        if (this.keyed.containsKey(key) && !FitsKey.isCommentStyleKey(key)) {
            int oldPos = this.indexOf(entry);
            this.internalRemove(oldPos, entry);
            if (oldPos < pos) {
                --pos;
            }
        }
        this.keyed.put(key, entry);
        if (pos >= this.ordered.size()) {
            pos = this.ordered.size() - 1;
            this.ordered.add(entry);
        } else {
            this.ordered.add(pos, entry);
        }
        if (pos < this.cursor.current) {
            this.cursor.current++;
        }
    }

    @Override
    public boolean add(VALUE e) {
        this.add(this.ordered.size(), e);
        return true;
    }

    public void update(String key, VALUE entry) {
        if (this.keyed.containsKey(key) && !FitsKey.isCommentStyleKey(key)) {
            int index = this.indexOf(this.get(key));
            this.remove(index);
            this.add(index, entry);
        } else {
            this.cursor.add(entry);
        }
    }

    @Override
    public boolean addAll(Collection<? extends VALUE> c) {
        for (CursorValue element : c) {
            this.add((VALUE)element);
        }
        return true;
    }

    @Override
    public void clear() {
        this.keyed.clear();
        this.ordered.clear();
    }

    @Override
    public boolean contains(Object o) {
        for (CursorValue entry : this.ordered) {
            if (!o.equals(entry)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        ArrayList values = new ArrayList(c);
        for (CursorValue entry : this.ordered) {
            values.remove(entry);
        }
        return values.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.keyed.containsKey(key);
    }

    public VALUE get(int n) {
        return (VALUE)((CursorValue)this.ordered.get(n));
    }

    public VALUE get(Object key) {
        return (VALUE)((CursorValue)this.keyed.get(key));
    }

    int indexOf(VALUE entry) {
        for (int index = 0; index < this.ordered.size(); ++index) {
            String searchKey = (String)entry.getKey();
            if (!searchKey.equals(((CursorValue)this.ordered.get(index)).getKey())) continue;
            return index;
        }
        throw new NoSuchElementException("Internal error: " + entry + " should have been found in " + this.ordered);
    }

    @Override
    public boolean isEmpty() {
        return this.ordered.isEmpty();
    }

    public HashedListIterator iterator() {
        return new HashedListIterator(0);
    }

    public Cursor<String, VALUE> iterator(int n) {
        if (n >= 0 && n <= this.ordered.size()) {
            return new HashedListIterator(n);
        }
        throw new NoSuchElementException("Invalid index for iterator:" + n);
    }

    public Cursor<String, VALUE> cursor() {
        return this.cursor;
    }

    public HashedListIterator iterator(String key) {
        CursorValue entry = (CursorValue)this.keyed.get(key);
        if (entry != null) {
            return new HashedListIterator(this.indexOf(entry));
        }
        throw new NoSuchElementException("Unknown key for iterator:" + key);
    }

    public boolean remove(int index) {
        if (index >= 0 && index < this.ordered.size()) {
            return this.internalRemove(index, (CursorValue)this.ordered.get(index));
        }
        return false;
    }

    private boolean internalRemove(int index, VALUE entry) {
        this.keyed.remove(entry.getKey());
        this.ordered.remove(index);
        if (index < this.cursor.current) {
            this.cursor.current--;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        for (int i = 0; i < this.ordered.size(); ++i) {
            CursorValue entry = (CursorValue)this.ordered.get(i);
            if (!o.equals(entry)) continue;
            return this.internalRemove(i, entry);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object element : c.toArray()) {
            result = this.remove(element) || result;
        }
        return result;
    }

    public boolean removeKey(Object key) {
        VALUE entry = this.get(key);
        if (entry != null) {
            this.internalRemove(this.indexOf(entry), entry);
            return true;
        }
        return false;
    }

    public boolean replaceKey(String oldKey, String newKey) {
        if (!this.keyed.containsKey(oldKey) || this.keyed.containsKey(newKey)) {
            return false;
        }
        CursorValue oldVal = (CursorValue)this.keyed.get(oldKey);
        this.keyed.remove(oldKey);
        this.keyed.put(newKey, oldVal);
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        HashedListIterator iter = this.iterator();
        boolean result = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (c.contains(o)) continue;
            iter.remove();
            result = true;
        }
        return result;
    }

    @Override
    public int size() {
        return this.ordered.size();
    }

    public void sort(Comparator<String> comp) {
        Collections.sort(this.ordered, new EntryComparator(comp));
    }

    @Override
    public Object[] toArray() {
        return this.ordered.toArray();
    }

    @Override
    public <T> T[] toArray(T[] o) {
        return this.ordered.toArray(o);
    }

    public String toString() {
        return this.ordered.toString();
    }

    private class HashedListIterator
    implements Cursor<String, VALUE> {
        private int current;

        HashedListIterator(int start) {
            this.current = start;
        }

        @Override
        public void add(String key, VALUE ref) {
            this.add((VALUE)ref);
        }

        @Override
        public void add(VALUE reference) {
            HashedList.this.add(this.current, reference);
            ++this.current;
            if (this.current > HashedList.this.size()) {
                this.current = HashedList.this.size();
            }
        }

        @Override
        public VALUE end() {
            this.current = HashedList.this.ordered.size() - 1;
            if (this.current < 0) {
                this.current = 0;
                return null;
            }
            return this.next();
        }

        @Override
        public boolean hasNext() {
            return this.current >= 0 && this.current < HashedList.this.ordered.size();
        }

        @Override
        public boolean hasPrev() {
            return this.current > 0;
        }

        @Override
        public VALUE next() {
            if (this.current < 0 || this.current >= HashedList.this.ordered.size()) {
                throw new NoSuchElementException("Outside list: " + this.current);
            }
            CursorValue entry = (CursorValue)HashedList.this.ordered.get(this.current);
            ++this.current;
            return entry;
        }

        @Override
        public VALUE next(int count) {
            for (int index = 1; index < count; ++index) {
                this.next();
            }
            return this.next();
        }

        @Override
        public VALUE prev() {
            if (this.current <= 0) {
                throw new NoSuchElementException("Before beginning of list");
            }
            return (CursorValue)HashedList.this.ordered.get(--this.current);
        }

        @Override
        public void remove() {
            if (this.current > 0 && this.current <= HashedList.this.ordered.size()) {
                HashedList.this.remove(--this.current);
            }
        }

        @Override
        public void setKey(String key) {
            CursorValue entry = (CursorValue)HashedList.this.keyed.get(key);
            this.current = entry != null ? HashedList.this.indexOf(entry) : HashedList.this.ordered.size();
        }
    }

    private static final class EntryComparator<VALUE extends CursorValue<String>>
    implements Comparator<VALUE> {
        private final Comparator<String> comp;

        private EntryComparator(Comparator<String> comp) {
            this.comp = comp;
        }

        @Override
        public int compare(VALUE o1, VALUE o2) {
            return this.comp.compare((String)o1.getKey(), (String)o2.getKey());
        }
    }
}

