/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import nom.tam.util.FitsEncoder;
import nom.tam.util.InputReader;
import nom.tam.util.type.ElementType;

public abstract class InputDecoder {
    private static final int BUFFER_SIZE = 23040;
    private static final int BYTE_MASK = 255;
    private static final int SHORT_MASK = 65535;
    private InputReader in;
    private InputBuffer buf = new InputBuffer(23040);

    protected InputDecoder() {
    }

    public InputDecoder(InputReader i) {
        this();
        this.setInput(i);
    }

    protected void setInput(InputReader i) {
        this.in = i;
    }

    protected InputBuffer getInputBuffer() {
        return this.buf;
    }

    boolean makeAvailable(int size) throws IOException {
        while (this.buf.buffer.remaining() < size) {
            if (this.buf.fetch()) continue;
            return false;
        }
        return true;
    }

    protected synchronized int read() throws IOException {
        return this.in.read();
    }

    protected synchronized int read(byte[] b, int start, int length) throws IOException {
        return this.in.read(b, start, length);
    }

    protected void readFully(byte[] b, int off, int len) throws EOFException, IOException {
        while (len > 0) {
            int n = this.read(b, off, len);
            if (n < 0) {
                throw new EOFException();
            }
            off += n;
            len -= n;
        }
    }

    public void readArrayFully(Object o) throws IOException, IllegalArgumentException {
        if (this.readArray(o) != FitsEncoder.computeSize(o)) {
            throw new EOFException("Incomplete array read (FITS encoding).");
        }
    }

    public abstract long readArray(Object var1) throws IOException, IllegalArgumentException;

    public void readImage(Object o) throws IOException, IllegalArgumentException {
        if (o == null) {
            return;
        }
        if (!o.getClass().isArray()) {
            throw new IllegalArgumentException("Not an array: " + o.getClass().getName());
        }
        long size = FitsEncoder.computeSize(o);
        if (size == 0L) {
            return;
        }
        this.getInputBuffer().loadBytes(size, 1);
        if (this.getImage(o) != size) {
            throw new EOFException("Incomplete image read.");
        }
    }

    private long getImage(Object o) throws IOException, IllegalArgumentException {
        int length = Array.getLength(o);
        if (length == 0) {
            return 0L;
        }
        if (o instanceof byte[]) {
            return this.buf.get((byte[])o, 0, length);
        }
        if (o instanceof short[]) {
            return this.buf.get((short[])o, 0, length) * 2;
        }
        if (o instanceof int[]) {
            return this.buf.get((int[])o, 0, length) * 4;
        }
        if (o instanceof float[]) {
            return this.buf.get((float[])o, 0, length) * 4;
        }
        if (o instanceof long[]) {
            return this.buf.get((long[])o, 0, length) * 8;
        }
        if (o instanceof double[]) {
            return this.buf.get((double[])o, 0, length) * 8;
        }
        if (!(o instanceof Object[])) {
            throw new IllegalArgumentException("Not a numerical image type: " + o.getClass().getName());
        }
        Object[] array = (Object[])o;
        long count = 0L;
        for (int i = 0; i < length; ++i) {
            try {
                count += this.getImage(array[i]);
                continue;
            }
            catch (EOFException e) {
                return this.eofCheck(e, count, -1L);
            }
        }
        return count;
    }

    long eofCheck(EOFException e, long got, long expected) throws EOFException {
        if (got == 0L) {
            if (e == null) {
                throw new EOFException();
            }
            throw e;
        }
        return got;
    }

    protected final class InputBuffer {
        private final byte[] data;
        private final ByteBuffer buffer;
        private Buffer view;
        private long pending = 0L;

        private InputBuffer(int size) {
            this.data = new byte[size];
            this.buffer = ByteBuffer.wrap(this.data);
        }

        protected void setByteOrder(ByteOrder order) {
            this.buffer.order(order);
        }

        protected ByteOrder byteOrder() {
            return this.buffer.order();
        }

        private boolean isViewingAs(Class<? extends Buffer> type) {
            if (this.view == null) {
                return false;
            }
            return type.isAssignableFrom(this.view.getClass());
        }

        private void assertView(ElementType<?> type) {
            if (!this.isViewingAs(type.bufferClass())) {
                this.view = type.asTypedBuffer(this.buffer);
            }
        }

        private void rewind() {
            this.buffer.rewind();
            this.view = null;
        }

        protected void loadBytes(long n, int size) {
            this.rewind();
            this.buffer.limit(0);
            this.pending = n * (long)size;
        }

        protected boolean loadOne(int size) throws IOException {
            this.pending = size;
            this.rewind();
            this.buffer.limit(0);
            return InputDecoder.this.makeAvailable(size);
        }

        private boolean fetch() throws IOException {
            int remaining = this.buffer.remaining();
            if (remaining > 0) {
                System.arraycopy(this.data, this.buffer.position(), this.data, 0, remaining);
            }
            this.rewind();
            int n = (int)Math.min(this.pending, (long)(this.data.length - remaining));
            n = InputDecoder.this.in.read(this.data, remaining, n);
            if (n < 0) {
                return false;
            }
            this.buffer.limit(remaining + n);
            this.pending -= (long)n;
            return true;
        }

        protected int get() throws IOException {
            if (InputDecoder.this.makeAvailable(1)) {
                this.view = null;
                return this.buffer.get() & 0xFF;
            }
            return -1;
        }

        protected int getUnsignedShort() throws IOException {
            if (InputDecoder.this.makeAvailable(2)) {
                this.view = null;
                return this.buffer.getShort() & 0xFFFF;
            }
            return -1;
        }

        protected int getInt() throws EOFException, IOException {
            if (InputDecoder.this.makeAvailable(4)) {
                this.view = null;
                return this.buffer.getInt();
            }
            throw new EOFException();
        }

        protected long getLong() throws EOFException, IOException {
            if (InputDecoder.this.makeAvailable(8)) {
                this.view = null;
                return this.buffer.getLong();
            }
            throw new EOFException();
        }

        protected float getFloat() throws EOFException, IOException {
            if (InputDecoder.this.makeAvailable(4)) {
                this.view = null;
                return this.buffer.getFloat();
            }
            throw new EOFException();
        }

        protected double getDouble() throws EOFException, IOException {
            if (InputDecoder.this.makeAvailable(8)) {
                this.view = null;
                return this.buffer.getDouble();
            }
            throw new EOFException();
        }

        protected int get(byte[] dst, int from, int n) throws EOFException, IOException {
            int got;
            int m;
            if (n == 1) {
                int i = this.get();
                if (i < 0) {
                    throw new EOFException();
                }
                dst[from] = (byte)i;
                return 1;
            }
            this.view = null;
            for (got = 0; got < n; got += m) {
                if (!InputDecoder.this.makeAvailable(1)) {
                    return (int)InputDecoder.this.eofCheck(null, got, n);
                }
                m = Math.min(n - got, this.buffer.remaining());
                this.buffer.get(dst, from + got, m);
            }
            return got;
        }

        protected int get(short[] dst, int from, int n) throws EOFException, IOException {
            if (n == 1 && !this.isViewingAs(ElementType.SHORT.bufferClass())) {
                int i = this.getUnsignedShort();
                if (i < 0) {
                    throw new EOFException();
                }
                dst[from] = (short)i;
                return 1;
            }
            return this.get(ElementType.SHORT, dst, from, n);
        }

        protected int get(int[] dst, int from, int n) throws EOFException, IOException {
            if (n == 1 && !this.isViewingAs(ElementType.INT.bufferClass())) {
                dst[from] = this.getInt();
                return 1;
            }
            return this.get(ElementType.INT, dst, from, n);
        }

        protected int get(long[] dst, int from, int n) throws EOFException, IOException {
            if (n == 1 && !this.isViewingAs(ElementType.LONG.bufferClass())) {
                dst[from] = this.getLong();
                return 1;
            }
            return this.get(ElementType.LONG, dst, from, n);
        }

        protected int get(float[] dst, int from, int n) throws EOFException, IOException {
            if (n == 1 && !this.isViewingAs(ElementType.FLOAT.bufferClass())) {
                dst[from] = this.getFloat();
                return 1;
            }
            return this.get(ElementType.FLOAT, dst, from, n);
        }

        protected int get(double[] dst, int from, int n) throws EOFException, IOException {
            if (n == 1 && !this.isViewingAs(ElementType.DOUBLE.bufferClass())) {
                dst[from] = this.getDouble();
                return 1;
            }
            return this.get(ElementType.DOUBLE, dst, from, n);
        }

        private <B extends Buffer> int get(ElementType<B> e, Object dst, int from, int n) throws EOFException, IOException {
            int got;
            int m;
            for (got = 0; got < n; got += m) {
                if (!InputDecoder.this.makeAvailable(e.size())) {
                    return (int)InputDecoder.this.eofCheck(null, got, n);
                }
                this.assertView(e);
                m = Math.min(n - got, this.view.remaining());
                e.getArray(this.view, dst, from + got, m);
                this.buffer.position(this.buffer.position() + m * e.size());
            }
            return got;
        }
    }
}

