/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import nom.tam.util.OutputWriter;
import nom.tam.util.type.ElementType;

public abstract class OutputEncoder {
    private static final int BUFFER_SIZE = 2880;
    protected OutputWriter out;
    private long count = 0L;
    private OutputBuffer buf = new OutputBuffer(2880);

    protected OutputEncoder() {
    }

    public OutputEncoder(OutputWriter o) {
        this();
        this.setOutput(o);
    }

    protected synchronized void setOutput(OutputWriter o) {
        this.out = o;
    }

    public synchronized long getCount() {
        return this.count + (long)this.buf.buffer.position();
    }

    protected OutputBuffer getOutputBuffer() {
        return this.buf;
    }

    void need(int bytes) throws IOException {
        if (this.buf.buffer.remaining() < bytes) {
            this.flush();
        }
    }

    protected synchronized void flush() throws IOException {
        int n = this.buf.buffer.position();
        this.out.write(this.buf.data, 0, n);
        this.count += (long)n;
        this.buf.rewind();
    }

    protected synchronized void write(int b) throws IOException {
        this.flush();
        this.out.write(b);
    }

    protected synchronized void write(byte[] b, int start, int length) throws IOException {
        this.flush();
        this.out.write(b, start, length);
    }

    public abstract void writeArray(Object var1) throws IOException, IllegalArgumentException;

    protected final class OutputBuffer {
        private final byte[] data;
        private final ByteBuffer buffer;
        private Buffer view;

        private OutputBuffer(int size) {
            this.data = new byte[size];
            this.buffer = ByteBuffer.wrap(this.data);
        }

        protected void setByteOrder(ByteOrder order) {
            this.buffer.order(order);
        }

        protected ByteOrder byteOrder() {
            return this.buffer.order();
        }

        private boolean isViewingAs(Class<? extends Buffer> type) {
            if (this.view == null) {
                return false;
            }
            return type.isAssignableFrom(this.view.getClass());
        }

        private void assertView(ElementType<?> type) {
            if (!this.isViewingAs(type.bufferClass())) {
                this.view = type.asTypedBuffer(this.buffer);
            }
        }

        private void rewind() {
            this.buffer.rewind();
            this.view = null;
        }

        protected void putByte(byte b) throws IOException {
            OutputEncoder.this.need(1);
            this.view = null;
            this.buffer.put(b);
        }

        protected void putShort(short s) throws IOException {
            OutputEncoder.this.need(2);
            this.view = null;
            this.buffer.putShort(s);
        }

        protected void putInt(int i) throws IOException {
            OutputEncoder.this.need(4);
            this.view = null;
            this.buffer.putInt(i);
        }

        protected void putLong(long l) throws IOException {
            OutputEncoder.this.need(8);
            this.view = null;
            this.buffer.putLong(l);
        }

        protected void putFloat(float f) throws IOException {
            OutputEncoder.this.need(4);
            this.view = null;
            this.buffer.putFloat(f);
        }

        protected void putDouble(double d) throws IOException {
            OutputEncoder.this.need(8);
            this.view = null;
            this.buffer.putDouble(d);
        }

        protected void put(byte[] src, int start, int length) throws IOException {
            int m;
            if (length == 1) {
                OutputEncoder.this.need(1);
                this.buffer.put(src[start]);
                return;
            }
            this.view = null;
            for (int got = 0; got < length; got += m) {
                OutputEncoder.this.need(1);
                m = Math.min(length - got, this.buffer.remaining());
                this.buffer.put(src, start + got, m);
            }
        }

        protected void put(short[] src, int start, int length) throws IOException {
            if (length == 1 && !this.isViewingAs(ElementType.SHORT.bufferClass())) {
                this.putShort(src[start]);
            } else {
                this.put(ElementType.SHORT, src, start, length);
            }
        }

        protected void put(int[] src, int start, int length) throws IOException {
            if (length == 1 && !this.isViewingAs(ElementType.INT.bufferClass())) {
                this.putInt(src[start]);
            } else {
                this.put(ElementType.INT, src, start, length);
            }
        }

        protected void put(long[] src, int start, int length) throws IOException {
            if (length == 1 && !this.isViewingAs(ElementType.LONG.bufferClass())) {
                this.putLong(src[start]);
            } else {
                this.put(ElementType.LONG, src, start, length);
            }
        }

        protected void put(float[] src, int start, int length) throws IOException {
            if (length == 1 && !this.isViewingAs(ElementType.FLOAT.bufferClass())) {
                this.putFloat(src[start]);
            } else {
                this.put(ElementType.FLOAT, src, start, length);
            }
        }

        protected void put(double[] src, int start, int length) throws IOException {
            if (length == 1 && !this.isViewingAs(ElementType.DOUBLE.bufferClass())) {
                this.putDouble(src[start]);
            } else {
                this.put(ElementType.DOUBLE, src, start, length);
            }
        }

        private <B extends Buffer> void put(ElementType<B> e, Object dst, int from, int n) throws EOFException, IOException {
            int m;
            for (int got = 0; got < n; got += m) {
                OutputEncoder.this.need(e.size());
                this.assertView(e);
                m = Math.min(n - got, this.view.remaining());
                e.putArray(this.view, dst, from + got, m);
                this.buffer.position(this.buffer.position() + m * e.size());
            }
        }
    }
}

