/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.util.Cursor;

public class Quantizer {
    private Long blankingValue;
    private double scale = 1.0;
    private double offset;

    public Quantizer(double scale, double offset, int blankingValue) {
        this(scale, offset, Long.valueOf(blankingValue));
    }

    public Quantizer(double scale, double offset, Long blankingValue) {
        this.scale = scale;
        this.offset = offset;
        this.blankingValue = blankingValue;
    }

    public long toLong(double value) {
        if (!Double.isFinite(value)) {
            if (this.blankingValue == null) {
                throw new IllegalStateException("No blanking value was defined.");
            }
            return this.blankingValue;
        }
        return Math.round((value - this.offset) / this.scale);
    }

    public double toDouble(long value) {
        if (this.blankingValue != null && value == this.blankingValue) {
            return Double.NaN;
        }
        return this.scale * (double)value + this.offset;
    }

    public boolean isDefault() {
        return this.scale == 1.0 && this.offset == 0.0 && this.blankingValue == null;
    }

    public void editImageHeader(Header h) {
        h.addValue((IFitsHeader)Standard.BSCALE, this.scale);
        h.addValue((IFitsHeader)Standard.BZERO, this.offset);
        if (this.blankingValue != null) {
            h.addValue((IFitsHeader)Standard.BLANK, this.blankingValue);
        } else {
            h.deleteKey(Standard.BLANK);
        }
    }

    public void editTableHeader(Header h, int col) {
        Cursor<String, HeaderCard> c = h.iterator();
        c.setKey(Standard.TFORMn.n(col + 1).key());
        c.add(HeaderCard.create(Standard.TSCALn.n(col + 1), this.scale));
        c.add(HeaderCard.create(Standard.TZEROn.n(col + 1), this.offset));
        if (this.blankingValue != null) {
            c.add(HeaderCard.create(Standard.TNULLn.n(col + 1), this.blankingValue));
        } else {
            h.deleteKey(Standard.TNULLn.n(col + 1));
        }
    }

    public static Quantizer fromImageHeader(Header h) {
        return new Quantizer(h.getDoubleValue(Standard.BSCALE, 1.0), h.getDoubleValue(Standard.BZERO, 0.0), h.containsKey(Standard.BLANK) ? Long.valueOf(h.getLongValue(Standard.BLANK)) : null);
    }

    public static Quantizer fromTableHeader(Header h, int col) {
        return new Quantizer(h.getDoubleValue(Standard.TSCALn.n(col + 1), 1.0), h.getDoubleValue(Standard.TZEROn.n(col + 1), 0.0), h.containsKey(Standard.TNULLn.n(col + 1)) ? Long.valueOf(h.getLongValue(Standard.TNULLn.n(col + 1))) : null);
    }
}

