/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.array;

import java.lang.reflect.Array;
import nom.tam.util.array.MultiArrayCopyFactory;
import nom.tam.util.array.MultiArrayIterator;

public final class MultiArrayCopier<Source, Destination> {
    private final MultiArrayIterator<Source> from;
    private final MultiArrayIterator<Destination> to;
    private Destination currentToArray;
    private int currentToArrayOffset;
    private int currentToArrayLength;
    private final MultiArrayCopyFactory<Source, Destination> copyFactory;

    public static <Source, Destination> void copyInto(Source fromArray, Destination toArray) {
        super.copyInto();
    }

    private MultiArrayCopier(Source fromArray, Destination toArray) {
        this.from = new MultiArrayIterator<Source>(fromArray);
        this.to = new MultiArrayIterator<Destination>(toArray);
        this.copyFactory = MultiArrayCopyFactory.select(this.from.deepComponentType(), this.to.deepComponentType());
    }

    private void copyInto() {
        Source current = this.from.next();
        while (current != null) {
            this.copyInto(current);
            current = this.from.next();
        }
    }

    private void copyInto(Source currentFromArray) {
        int currentFromArrayOffset = 0;
        int currentFromArrayLength = Array.getLength(currentFromArray);
        while (currentFromArrayOffset < currentFromArrayLength) {
            if (this.currentToArray == null || this.currentToArrayOffset >= this.currentToArrayLength) {
                this.currentToArray = this.to.next();
                this.currentToArrayOffset = 0;
                this.currentToArrayLength = Array.getLength(this.currentToArray);
            }
            int length = Math.min(this.currentToArrayLength - this.currentToArrayOffset, currentFromArrayLength - currentFromArrayOffset);
            this.copyFactory.arraycopy(currentFromArray, currentFromArrayOffset, this.currentToArray, this.currentToArrayOffset, length);
            currentFromArrayOffset += length;
            this.currentToArrayOffset += length;
        }
    }
}

