/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.array;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Deprecated
@SuppressFBWarnings(value={"SING_SINGLETON_HAS_NONPRIVATE_CONSTRUCTOR"}, justification="warning persists despite private constructor")
public class MultiArrayCopyFactory<Source, Destination> {
    private static final Map<Class<?>, Map<Class<?>, MultiArrayCopyFactory<?, ?>>> FACTORIES;
    private static final MultiArrayCopyFactory<Object, Object> GENERIC;

    private MultiArrayCopyFactory() {
    }

    public static synchronized MultiArrayCopyFactory<?, ?> select(Class<?> primitiveType, Class<?> primitiveType2) {
        MultiArrayCopyFactory<?, ?> to;
        Map<Class<?>, MultiArrayCopyFactory<?, ?>> from = FACTORIES.get(primitiveType);
        if (from != null && (to = from.get(primitiveType2)) != null) {
            return to;
        }
        return GENERIC;
    }

    public void arraycopy(Source src, int srcPos, Destination dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    static {
        GENERIC = new Generic();
        HashMap factories = new HashMap();
        HashMap byteMap = new HashMap();
        byteMap.put(Byte.TYPE, new MultiArrayCopyFactory());
        byteMap.put(Character.TYPE, new ByteToChar());
        byteMap.put(Short.TYPE, new ByteToShort());
        byteMap.put(Integer.TYPE, new ByteToInt());
        byteMap.put(Long.TYPE, new ByteToLong());
        byteMap.put(Float.TYPE, new ByteToFloat());
        byteMap.put(Double.TYPE, new ByteToDouble());
        factories.put(Byte.TYPE, Collections.unmodifiableMap(byteMap));
        HashMap charMap = new HashMap();
        charMap.put(Byte.TYPE, new CharToByte());
        charMap.put(Character.TYPE, new MultiArrayCopyFactory());
        charMap.put(Short.TYPE, new CharToShort());
        charMap.put(Integer.TYPE, new CharToInt());
        charMap.put(Long.TYPE, new CharToLong());
        charMap.put(Float.TYPE, new CharToFloat());
        charMap.put(Double.TYPE, new CharToDouble());
        factories.put(Character.TYPE, Collections.unmodifiableMap(charMap));
        HashMap shortMap = new HashMap();
        shortMap.put(Byte.TYPE, new ShortToByte());
        shortMap.put(Character.TYPE, new ShortToChar());
        shortMap.put(Short.TYPE, new MultiArrayCopyFactory());
        shortMap.put(Integer.TYPE, new ShortToInt());
        shortMap.put(Long.TYPE, new ShortToLong());
        shortMap.put(Float.TYPE, new ShortToFloat());
        shortMap.put(Double.TYPE, new ShortToDouble());
        factories.put(Short.TYPE, Collections.unmodifiableMap(shortMap));
        HashMap intMap = new HashMap();
        intMap.put(Byte.TYPE, new IntToByte());
        intMap.put(Character.TYPE, new IntToChar());
        intMap.put(Short.TYPE, new IntToShort());
        intMap.put(Integer.TYPE, new MultiArrayCopyFactory());
        intMap.put(Long.TYPE, new IntToLong());
        intMap.put(Float.TYPE, new IntToFloat());
        intMap.put(Double.TYPE, new IntToDouble());
        factories.put(Integer.TYPE, Collections.unmodifiableMap(intMap));
        HashMap longMap = new HashMap();
        longMap.put(Byte.TYPE, new LongToByte());
        longMap.put(Character.TYPE, new LongToChar());
        longMap.put(Short.TYPE, new LongToShort());
        longMap.put(Integer.TYPE, new LongToInt());
        longMap.put(Long.TYPE, new MultiArrayCopyFactory());
        longMap.put(Float.TYPE, new LongToFloat());
        longMap.put(Double.TYPE, new LongToDouble());
        factories.put(Long.TYPE, Collections.unmodifiableMap(longMap));
        HashMap floatMap = new HashMap();
        floatMap.put(Byte.TYPE, new FloatToByte());
        floatMap.put(Character.TYPE, new FloatToChar());
        floatMap.put(Short.TYPE, new FloatToShort());
        floatMap.put(Integer.TYPE, new FloatToInt());
        floatMap.put(Long.TYPE, new FloatToLong());
        floatMap.put(Float.TYPE, new MultiArrayCopyFactory());
        floatMap.put(Double.TYPE, new FloatToDouble());
        factories.put(Float.TYPE, Collections.unmodifiableMap(floatMap));
        HashMap doubleMap = new HashMap();
        doubleMap.put(Byte.TYPE, new DoubleToByte());
        doubleMap.put(Character.TYPE, new DoubleToChar());
        doubleMap.put(Short.TYPE, new DoubleToShort());
        doubleMap.put(Integer.TYPE, new DoubleToInt());
        doubleMap.put(Long.TYPE, new DoubleToLong());
        doubleMap.put(Float.TYPE, new DoubleToFloat());
        doubleMap.put(Double.TYPE, new MultiArrayCopyFactory());
        factories.put(Double.TYPE, Collections.unmodifiableMap(doubleMap));
        FACTORIES = Collections.unmodifiableMap(factories);
    }

    private static final class Generic
    extends MultiArrayCopyFactory<Object, Object> {
        private Generic() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            System.arraycopy(srcO, srcPos, destO, destPos, length);
        }
    }

    private static final class ByteToChar
    extends MultiArrayCopyFactory<byte[], char[]> {
        private ByteToChar() {
        }

        @Override
        public void arraycopy(byte[] src, int srcPos, char[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (char)src[index + srcPos];
            }
        }
    }

    private static final class ByteToShort
    extends MultiArrayCopyFactory<byte[], short[]> {
        private ByteToShort() {
        }

        @Override
        public void arraycopy(byte[] src, int srcPos, short[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class ByteToInt
    extends MultiArrayCopyFactory<byte[], int[]> {
        private ByteToInt() {
        }

        @Override
        public void arraycopy(byte[] src, int srcPos, int[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class ByteToLong
    extends MultiArrayCopyFactory<byte[], long[]> {
        private ByteToLong() {
        }

        @Override
        public void arraycopy(byte[] src, int srcPos, long[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class ByteToFloat
    extends MultiArrayCopyFactory<byte[], float[]> {
        private ByteToFloat() {
        }

        @Override
        public void arraycopy(byte[] src, int srcPos, float[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class ByteToDouble
    extends MultiArrayCopyFactory<byte[], double[]> {
        private ByteToDouble() {
        }

        @Override
        public void arraycopy(byte[] src, int srcPos, double[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class CharToByte
    extends MultiArrayCopyFactory<char[], byte[]> {
        private CharToByte() {
        }

        @Override
        public void arraycopy(char[] src, int srcPos, byte[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (byte)src[index + srcPos];
            }
        }
    }

    private static final class CharToShort
    extends MultiArrayCopyFactory<char[], short[]> {
        private CharToShort() {
        }

        @Override
        public void arraycopy(char[] src, int srcPos, short[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (short)src[index + srcPos];
            }
        }
    }

    private static final class CharToInt
    extends MultiArrayCopyFactory<char[], int[]> {
        private CharToInt() {
        }

        @Override
        public void arraycopy(char[] src, int srcPos, int[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class CharToLong
    extends MultiArrayCopyFactory<char[], long[]> {
        private CharToLong() {
        }

        @Override
        public void arraycopy(char[] src, int srcPos, long[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class CharToFloat
    extends MultiArrayCopyFactory<char[], float[]> {
        private CharToFloat() {
        }

        @Override
        public void arraycopy(char[] src, int srcPos, float[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class CharToDouble
    extends MultiArrayCopyFactory<char[], double[]> {
        private CharToDouble() {
        }

        @Override
        public void arraycopy(char[] src, int srcPos, double[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class ShortToByte
    extends MultiArrayCopyFactory<short[], byte[]> {
        private ShortToByte() {
        }

        @Override
        public void arraycopy(short[] src, int srcPos, byte[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (byte)src[index + srcPos];
            }
        }
    }

    private static final class ShortToChar
    extends MultiArrayCopyFactory<short[], char[]> {
        private ShortToChar() {
        }

        @Override
        public void arraycopy(short[] src, int srcPos, char[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (char)src[index + srcPos];
            }
        }
    }

    private static final class ShortToInt
    extends MultiArrayCopyFactory<short[], int[]> {
        private ShortToInt() {
        }

        @Override
        public void arraycopy(short[] src, int srcPos, int[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class ShortToLong
    extends MultiArrayCopyFactory<short[], long[]> {
        private ShortToLong() {
        }

        @Override
        public void arraycopy(short[] src, int srcPos, long[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class ShortToFloat
    extends MultiArrayCopyFactory<short[], float[]> {
        private ShortToFloat() {
        }

        @Override
        public void arraycopy(short[] src, int srcPos, float[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class ShortToDouble
    extends MultiArrayCopyFactory<short[], double[]> {
        private ShortToDouble() {
        }

        @Override
        public void arraycopy(short[] src, int srcPos, double[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class IntToByte
    extends MultiArrayCopyFactory<int[], byte[]> {
        private IntToByte() {
        }

        @Override
        public void arraycopy(int[] src, int srcPos, byte[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (byte)src[index + srcPos];
            }
        }
    }

    private static final class IntToChar
    extends MultiArrayCopyFactory<int[], char[]> {
        private IntToChar() {
        }

        @Override
        public void arraycopy(int[] src, int srcPos, char[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (char)src[index + srcPos];
            }
        }
    }

    private static final class IntToShort
    extends MultiArrayCopyFactory<int[], short[]> {
        private IntToShort() {
        }

        @Override
        public void arraycopy(int[] src, int srcPos, short[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (short)src[index + srcPos];
            }
        }
    }

    private static final class IntToLong
    extends MultiArrayCopyFactory<int[], long[]> {
        private IntToLong() {
        }

        @Override
        public void arraycopy(int[] src, int srcPos, long[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class IntToFloat
    extends MultiArrayCopyFactory<int[], float[]> {
        private IntToFloat() {
        }

        @Override
        public void arraycopy(int[] src, int srcPos, float[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class IntToDouble
    extends MultiArrayCopyFactory<int[], double[]> {
        private IntToDouble() {
        }

        @Override
        public void arraycopy(int[] src, int srcPos, double[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class LongToByte
    extends MultiArrayCopyFactory<long[], byte[]> {
        private LongToByte() {
        }

        @Override
        public void arraycopy(long[] src, int srcPos, byte[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (byte)src[index + srcPos];
            }
        }
    }

    private static final class LongToChar
    extends MultiArrayCopyFactory<long[], char[]> {
        private LongToChar() {
        }

        @Override
        public void arraycopy(long[] src, int srcPos, char[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (char)src[index + srcPos];
            }
        }
    }

    private static final class LongToShort
    extends MultiArrayCopyFactory<long[], short[]> {
        private LongToShort() {
        }

        @Override
        public void arraycopy(long[] src, int srcPos, short[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (short)src[index + srcPos];
            }
        }
    }

    private static final class LongToInt
    extends MultiArrayCopyFactory<long[], int[]> {
        private LongToInt() {
        }

        @Override
        public void arraycopy(long[] src, int srcPos, int[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (int)src[index + srcPos];
            }
        }
    }

    private static final class LongToFloat
    extends MultiArrayCopyFactory<long[], float[]> {
        private LongToFloat() {
        }

        @Override
        public void arraycopy(long[] src, int srcPos, float[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class LongToDouble
    extends MultiArrayCopyFactory<long[], double[]> {
        private LongToDouble() {
        }

        @Override
        public void arraycopy(long[] src, int srcPos, double[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class FloatToByte
    extends MultiArrayCopyFactory<float[], byte[]> {
        private FloatToByte() {
        }

        @Override
        public void arraycopy(float[] src, int srcPos, byte[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (byte)Math.round(src[index + srcPos]);
            }
        }
    }

    private static final class FloatToChar
    extends MultiArrayCopyFactory<float[], char[]> {
        private FloatToChar() {
        }

        @Override
        public void arraycopy(float[] src, int srcPos, char[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (char)Math.round(src[index + srcPos]);
            }
        }
    }

    private static final class FloatToShort
    extends MultiArrayCopyFactory<float[], short[]> {
        private FloatToShort() {
        }

        @Override
        public void arraycopy(float[] src, int srcPos, short[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (short)Math.round(src[index + srcPos]);
            }
        }
    }

    private static final class FloatToInt
    extends MultiArrayCopyFactory<float[], int[]> {
        private FloatToInt() {
        }

        @Override
        public void arraycopy(float[] src, int srcPos, int[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = Math.round(src[index + srcPos]);
            }
        }
    }

    private static final class FloatToLong
    extends MultiArrayCopyFactory<float[], long[]> {
        private FloatToLong() {
        }

        @Override
        public void arraycopy(float[] src, int srcPos, long[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = Math.round(src[index + srcPos]);
            }
        }
    }

    private static final class FloatToDouble
    extends MultiArrayCopyFactory<float[], double[]> {
        private FloatToDouble() {
        }

        @Override
        public void arraycopy(float[] src, int srcPos, double[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static final class DoubleToByte
    extends MultiArrayCopyFactory<double[], byte[]> {
        private DoubleToByte() {
        }

        @Override
        public void arraycopy(double[] src, int srcPos, byte[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (byte)Math.round(src[index + srcPos]);
            }
        }
    }

    private static final class DoubleToChar
    extends MultiArrayCopyFactory<double[], char[]> {
        private DoubleToChar() {
        }

        @Override
        public void arraycopy(double[] src, int srcPos, char[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (char)Math.round(src[index + srcPos]);
            }
        }
    }

    private static final class DoubleToShort
    extends MultiArrayCopyFactory<double[], short[]> {
        private DoubleToShort() {
        }

        @Override
        public void arraycopy(double[] src, int srcPos, short[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (short)Math.round(src[index + srcPos]);
            }
        }
    }

    private static final class DoubleToInt
    extends MultiArrayCopyFactory<double[], int[]> {
        private DoubleToInt() {
        }

        @Override
        public void arraycopy(double[] src, int srcPos, int[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (int)Math.round(src[index + srcPos]);
            }
        }
    }

    private static final class DoubleToLong
    extends MultiArrayCopyFactory<double[], long[]> {
        private DoubleToLong() {
        }

        @Override
        public void arraycopy(double[] src, int srcPos, long[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = Math.round(src[index + srcPos]);
            }
        }
    }

    private static final class DoubleToFloat
    extends MultiArrayCopyFactory<double[], float[]> {
        private DoubleToFloat() {
        }

        @Override
        public void arraycopy(double[] src, int srcPos, float[] dest, int destPos, int length) {
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (float)src[index + srcPos];
            }
        }
    }
}

