/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.array;

import java.lang.reflect.Array;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.array.MultiArrayPointer;

public class MultiArrayIterator<BaseArray> {
    private final BaseArray baseArray;
    private final boolean baseIsNoSubArray;
    private boolean baseNextCalled = false;
    private final MultiArrayPointer pointer;

    public MultiArrayIterator(BaseArray baseArray) {
        this.baseArray = baseArray;
        this.baseIsNoSubArray = !MultiArrayPointer.isSubArray(this.baseArray);
        this.pointer = new MultiArrayPointer(this.baseArray);
    }

    public Class<?> deepComponentType() {
        return ArrayFuncs.getBaseClass(this.baseArray);
    }

    public BaseArray next() {
        if (this.baseIsNoSubArray) {
            if (this.baseNextCalled) {
                return null;
            }
            this.baseNextCalled = true;
            return this.baseArray;
        }
        Object result = null;
        while (result == null || Array.getLength(result) == 0) {
            result = this.pointer.next();
            if (result != MultiArrayPointer.END) continue;
            return null;
        }
        return (BaseArray)result;
    }

    public void reset() {
        if (this.baseIsNoSubArray) {
            this.baseNextCalled = false;
        } else {
            this.pointer.reset();
        }
    }

    public int size() {
        return (int)ArrayFuncs.countElements(this.baseArray);
    }
}

