/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.type;

import java.nio.ByteBuffer;
import nom.tam.util.type.ElementType;

class ByteType
extends ElementType<ByteBuffer> {
    protected ByteType() {
        super(1, false, Byte.TYPE, Byte.class, ByteBuffer.class, 'B', 8);
    }

    @Override
    public void appendBuffer(ByteBuffer buffer, ByteBuffer dataToAppend) {
        byte[] temp = new byte[Math.min(1024, dataToAppend.remaining())];
        while (dataToAppend.hasRemaining()) {
            int nrObBytes = Math.min(temp.length, dataToAppend.remaining());
            dataToAppend.get(temp, 0, nrObBytes);
            buffer.put(temp, 0, nrObBytes);
        }
    }

    @Override
    public ByteBuffer asTypedBuffer(ByteBuffer buffer) {
        return buffer;
    }

    @Override
    public void getArray(ByteBuffer buffer, Object array, int offset, int length) {
        buffer.get((byte[])array, offset, length);
    }

    @Override
    public Object newArray(int length) {
        return new byte[length];
    }

    @Override
    public void putArray(ByteBuffer buffer, Object array, int offset, int length) {
        buffer.put((byte[])array, offset, length);
    }

    @Override
    public ByteBuffer sliceBuffer(ByteBuffer buffer) {
        return buffer.slice();
    }

    @Override
    public ByteBuffer wrap(Object array) {
        return ByteBuffer.wrap((byte[])array);
    }
}

