/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.type;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import nom.tam.util.type.ElementType;

class DoubleType
extends ElementType<DoubleBuffer> {
    private static final int SIZE = 8;

    protected DoubleType() {
        super(8, false, Double.TYPE, Double.class, DoubleBuffer.class, 'D', -64);
    }

    @Override
    public void appendBuffer(DoubleBuffer buffer, DoubleBuffer dataToAppend) {
        double[] temp = new double[Math.min(1024, dataToAppend.remaining())];
        while (dataToAppend.hasRemaining()) {
            int nrObBytes = Math.min(temp.length, dataToAppend.remaining());
            dataToAppend.get(temp, 0, nrObBytes);
            buffer.put(temp, 0, nrObBytes);
        }
    }

    @Override
    public DoubleBuffer asTypedBuffer(ByteBuffer buffer) {
        return buffer.asDoubleBuffer();
    }

    @Override
    public void getArray(DoubleBuffer buffer, Object array, int offset, int length) {
        buffer.get((double[])array, offset, length);
    }

    @Override
    public Object newArray(int length) {
        return new double[length];
    }

    @Override
    public void putArray(DoubleBuffer buffer, Object array, int offset, int length) {
        buffer.put((double[])array, offset, length);
    }

    @Override
    public DoubleBuffer sliceBuffer(DoubleBuffer buffer) {
        return buffer.slice();
    }

    @Override
    public DoubleBuffer wrap(Object array) {
        return DoubleBuffer.wrap((double[])array);
    }
}

