/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.type;

import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nom.tam.fits.FitsException;
import nom.tam.fits.header.Bitpix;
import nom.tam.util.type.BooleanType;
import nom.tam.util.type.ByteType;
import nom.tam.util.type.CharType;
import nom.tam.util.type.DoubleType;
import nom.tam.util.type.FloatType;
import nom.tam.util.type.IntType;
import nom.tam.util.type.LongType;
import nom.tam.util.type.ShortType;
import nom.tam.util.type.StringType;
import nom.tam.util.type.UnknownType;

public abstract class ElementType<B extends Buffer> {
    private static final int VARIABLE_SIZE = -1;
    public static final int COPY_BLOCK_SIZE = 1024;
    private final int bitPix;
    private final Class<B> bufferClass;
    private final Class<?> primitiveClass;
    private final int size;
    private final char javaType;
    private final Class<?> wrapperClass;
    public static final ElementType<Buffer> BOOLEAN = new BooleanType();
    public static final ElementType<ByteBuffer> BYTE = new ByteType();
    public static final ElementType<ByteBuffer> CHAR = new CharType();
    public static final ElementType<DoubleBuffer> DOUBLE = new DoubleType();
    public static final ElementType<FloatBuffer> FLOAT = new FloatType();
    public static final ElementType<IntBuffer> INT = new IntType();
    public static final ElementType<LongBuffer> LONG = new LongType();
    public static final ElementType<ShortBuffer> SHORT = new ShortType();
    public static final ElementType<Buffer> STRING = new StringType();
    public static final ElementType<Buffer> UNKNOWN = new UnknownType();
    private static Map<Class<?>, ElementType<?>> byClass;
    private static Map<Character, ElementType<?>> byType;

    protected ElementType(int size, boolean varSize, Class<?> primitiveClass, Class<?> wrapperClass, Class<B> bufferClass, char type, int bitPix) {
        this.size = varSize ? -1 : size;
        this.primitiveClass = primitiveClass;
        this.wrapperClass = wrapperClass;
        this.bufferClass = bufferClass;
        this.javaType = type;
        this.bitPix = bitPix;
    }

    public void appendBuffer(B buffer, B dataToAppend) {
        throw new UnsupportedOperationException("no primitive type");
    }

    public void appendToByteBuffer(ByteBuffer byteBuffer, B dataToAppend) {
        byte[] temp = new byte[Math.min(1024 * this.size(), ((Buffer)dataToAppend).remaining() * this.size())];
        B typedBuffer = this.asTypedBuffer(ByteBuffer.wrap(temp));
        Object array = this.newArray(Math.min(1024, ((Buffer)dataToAppend).remaining()));
        while (((Buffer)dataToAppend).hasRemaining()) {
            int part = Math.min(1024, ((Buffer)dataToAppend).remaining());
            this.getArray(dataToAppend, array, part);
            this.putArray(typedBuffer, array, part);
            byteBuffer.put(temp, 0, part * this.size());
        }
    }

    public B asTypedBuffer(ByteBuffer buffer) {
        throw new UnsupportedOperationException("no primitive buffer available");
    }

    public int bitPix() {
        return this.bitPix;
    }

    public Class<B> bufferClass() {
        return this.bufferClass;
    }

    public ByteBuffer convertToByteBuffer(Object array) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[Array.getLength(array) * this.size()]);
        this.putArray(this.asTypedBuffer(buffer), array);
        buffer.rewind();
        return buffer;
    }

    public final void getArray(B buffer, Object array) {
        this.getArray(buffer, array, Array.getLength(array));
    }

    public final void getArray(B buffer, Object array, int length) {
        this.getArray(buffer, array, 0, length);
    }

    public void getArray(B buffer, Object array, int offset, int length) {
        throw new UnsupportedOperationException("no primitive type");
    }

    public boolean isVariableSize() {
        return this.size == -1;
    }

    @Deprecated
    public final boolean individualSize() {
        return this.isVariableSize();
    }

    public boolean is(ElementType<? extends Buffer> other) {
        return this.bitPix == other.bitPix();
    }

    public Object newArray(int length) {
        return null;
    }

    public final B newBuffer(int length) {
        return this.wrap(this.newArray(length));
    }

    public final B newBuffer(long length) throws IllegalArgumentException {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Currently only buffers of 32-bit integer size are supported.");
        }
        return this.newBuffer((int)length);
    }

    public Class<?> primitiveClass() {
        return this.primitiveClass;
    }

    public final void putArray(B buffer, Object array) {
        this.putArray(buffer, array, Array.getLength(array));
    }

    public final void putArray(B buffer, Object array, int length) {
        this.putArray(buffer, array, 0, length);
    }

    public void putArray(B buffer, Object array, int offset, int length) {
        throw new UnsupportedOperationException("no primitive type");
    }

    public int size() {
        return this.size;
    }

    public int size(Object instance) {
        if (instance == null) {
            return 0;
        }
        Class<?> cl = instance.getClass();
        if (!this.primitiveClass.isAssignableFrom(cl) && !this.wrapperClass.isAssignableFrom(cl)) {
            throw new IllegalArgumentException("Class " + cl.getName() + " does not match type " + this.getClass().getSimpleName());
        }
        return this.size();
    }

    public B sliceBuffer(B buffer) {
        return null;
    }

    public char type() {
        return this.javaType;
    }

    public B wrap(Object array) {
        return null;
    }

    public Class<?> wrapperClass() {
        return this.wrapperClass;
    }

    public static ElementType<Buffer> forDataID(char type) {
        return ElementType.cast(byType.get(Character.valueOf(type)));
    }

    public static <B extends Buffer> ElementType<B> forClass(Class<?> clazz) {
        ElementType<?> primitiveType = byClass.get(clazz);
        if (primitiveType == null) {
            for (Class<?> interf : clazz.getInterfaces()) {
                primitiveType = byClass.get(interf);
                if (primitiveType == null) continue;
                return ElementType.cast(primitiveType);
            }
            return ElementType.forClass(clazz.getSuperclass());
        }
        return ElementType.cast(primitiveType);
    }

    public static <B extends Buffer> ElementType<B> forBuffer(B b) {
        return ElementType.forClass(b.getClass());
    }

    public static ElementType<Buffer> forBitpix(int bitPix) {
        try {
            return ElementType.cast(Bitpix.forValue(bitPix).getElementType());
        }
        catch (FitsException e) {
            return null;
        }
    }

    public static ElementType<Buffer> forNearestBitpix(int bitPix) {
        try {
            return ElementType.cast(Bitpix.forValue(bitPix, true).getElementType());
        }
        catch (FitsException e) {
            return UNKNOWN;
        }
    }

    private static <B extends Buffer> ElementType<B> cast(ElementType<?> e) {
        return e;
    }

    private static ElementType<?>[] values() {
        return new ElementType[]{BOOLEAN, BYTE, CHAR, DOUBLE, FLOAT, INT, LONG, SHORT, STRING, UNKNOWN};
    }

    static {
        HashMap initialByClass = new HashMap();
        HashMap initialByType = new HashMap();
        for (ElementType<?> type : ElementType.values()) {
            initialByType.put(Character.valueOf(type.type()), type);
            initialByClass.put(type.primitiveClass(), type);
            initialByClass.put(type.wrapperClass(), type);
            if (type.bufferClass() == null) continue;
            initialByClass.put(type.bufferClass(), type);
        }
        byClass = Collections.unmodifiableMap(initialByClass);
        byType = Collections.unmodifiableMap(initialByType);
    }
}

