/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.type;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import nom.tam.util.type.ElementType;

class FloatType
extends ElementType<FloatBuffer> {
    private static final int SIZE = 4;

    protected FloatType() {
        super(4, false, Float.TYPE, Float.class, FloatBuffer.class, 'F', -32);
    }

    @Override
    public void appendBuffer(FloatBuffer buffer, FloatBuffer dataToAppend) {
        float[] temp = new float[Math.min(1024, dataToAppend.remaining())];
        while (dataToAppend.hasRemaining()) {
            int nrObBytes = Math.min(temp.length, dataToAppend.remaining());
            dataToAppend.get(temp, 0, nrObBytes);
            buffer.put(temp, 0, nrObBytes);
        }
    }

    @Override
    public FloatBuffer asTypedBuffer(ByteBuffer buffer) {
        return buffer.asFloatBuffer();
    }

    @Override
    public void getArray(FloatBuffer buffer, Object array, int offset, int length) {
        buffer.get((float[])array, offset, length);
    }

    @Override
    public Object newArray(int length) {
        return new float[length];
    }

    @Override
    public void putArray(FloatBuffer buffer, Object array, int offset, int length) {
        buffer.put((float[])array, offset, length);
    }

    @Override
    public FloatBuffer sliceBuffer(FloatBuffer buffer) {
        return buffer.slice();
    }

    @Override
    public FloatBuffer wrap(Object array) {
        return FloatBuffer.wrap((float[])array);
    }
}

